
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;


int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    string s;
    cin >> s;

    vector<string> partitions;

    int m = -1;
    for (char c : s) {
        if (c == '<') {
            partitions.push_back("<");
            m++;
        }
        else {
            if (m == -1) {
                printf("No");
                return 0;
            }
            partitions[m].push_back(c);
        }
    }

    vector<int> visited;
    map<int, int> startToEnd;

    int j = 0;
    for (string p : partitions) {
        if (find(visited.begin(), visited.end(), j) != visited.end()) {
            continue;
        }
        string alphabet = "abcdefghijklmnopqrstuvwxyz";
        int len = p.length();
        if (p[len - 1] != '>') {
            printf("No");
            return 0;
        }

        string endTag = "</";
        for (int i = 1; i < len - 1; i++) {
            if (find(alphabet.begin(), alphabet.end(), p[i]) == alphabet.end()) {
                printf("No");
                return 0;
            }
            endTag.push_back(p[i]);
        }
        endTag.push_back('>');
        
        auto findEnd = find(partitions.begin(), partitions.end(), endTag);
        if (findEnd == partitions.end()) {
            printf("No");
            return 0;
        }
        startToEnd[j] = findEnd - partitions.begin();
        visited.push_back(findEnd - partitions.begin());
        j++;
    }

    for (auto& m : startToEnd) {
        if ((m.first - m.second) % 2 == 0) {
            printf("No");
            return 0;
        }
    }

    printf("Yes");

   
}
